/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.machine;

import com.google.inject.Inject;
import info.msxlaunchers.openmsx.common.FileTypeUtils;
import info.msxlaunchers.openmsx.common.FileUtils;
import info.msxlaunchers.openmsx.launcher.data.settings.Settings;
import info.msxlaunchers.openmsx.launcher.persistence.settings.SettingsPersister;
import info.msxlaunchers.openmsx.machine.InvalidMachinesDirectoryException;
import info.msxlaunchers.openmsx.machine.MachineLister;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

final class OpenMSXMachineLister
implements MachineLister {
    private final SettingsPersister settingsPersister;
    private final String HARDWARE_CONFIG_FILENAME = "hardwareconfig.xml";

    @Inject
    OpenMSXMachineLister(SettingsPersister settingsPersister) {
        this.settingsPersister = Objects.requireNonNull(settingsPersister);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Set<String> get() throws InvalidMachinesDirectoryException, IOException {
        Settings settings = this.settingsPersister.getSettings();
        HashSet<String> machines = new HashSet<String>();
        String openMSXMachinesFullPath = settings.getOpenMSXMachinesFullPath();
        if (openMSXMachinesFullPath == null) throw new InvalidMachinesDirectoryException();
        File openMSXMachinesDirectory = new File(openMSXMachinesFullPath);
        if (!openMSXMachinesDirectory.isDirectory()) throw new InvalidMachinesDirectoryException();
        File[] fileList = openMSXMachinesDirectory.listFiles();
        if (fileList == null) return Collections.unmodifiableSet(machines);
        for (File file : fileList) {
            if (this.isValidOpenMSXMachineFile(file)) {
                machines.add(FileUtils.getFileNameWithoutExtension(file));
                continue;
            }
            if (!this.isValidOpenMSXMachineDirectory(file)) continue;
            machines.add(file.getName());
        }
        return Collections.unmodifiableSet(machines);
    }

    private boolean isValidOpenMSXMachineFile(File file) {
        return FileTypeUtils.isXML(file);
    }

    private boolean isValidOpenMSXMachineDirectory(File directory) {
        boolean valid = directory.isDirectory();
        if (valid) {
            File hardwareConfigFile = new File(directory, "hardwareconfig.xml");
            valid = hardwareConfigFile.exists();
        }
        return valid;
    }
}

